// サーバーURL設定スクリプト
// このスクリプトをアプリのページで実行すると、拡張機能にサーバーURLを保存します

(async function () {
	const serverUrl = window.location.origin;

	try {
		await chrome.storage.local.set({ serverUrl: serverUrl });
		console.log('✅ サーバーURLを保存しました:', serverUrl);
		alert(`✅ サーバーURLを保存しました: ${serverUrl}\n\nこれで拡張機能が正しく動作します。`);
	} catch (error) {
		console.error('❌ エラー:', error);
		alert('❌ エラー: ' + error.message);
	}
})();
