document.getElementById('scrapeBtn').addEventListener('click', async () => {
  const statusDiv = document.getElementById('status');
  const btn = document.getElementById('scrapeBtn');

  try {
    btn.disabled = true;
    statusDiv.className = 'loading';
    statusDiv.textContent = 'データを抽出中...';

    // 現在のアクティブなタブを取得
    const [tab] = await chrome.tabs.query({ active: true, currentWindow: true });

    if (!tab.url.includes('ana-slo.com')) {
      throw new Error('ana-slo.com のページで実行してください');
    }

    // コンテンツスクリプトを実行してデータを取得
    const result = await chrome.scripting.executeScript({
      target: { tabId: tab.id },
      files: ['content_script.js']
    });

    if (!result || !result[0] || !result[0].result) {
      throw new Error('データの取得に失敗しました');
    }

    const data = result[0].result;

    if (data.error) {
      throw new Error(data.error);
    }

    statusDiv.textContent = `データ送信中... (${data.rows.length}件)`;

    // 固定サーバーURL
    const serverUrl = 'https://slot-data-app.win';

    // サーバーにデータを送信
    const response = await fetch(`${serverUrl}/api/receive_data`, {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json',
      },
      body: JSON.stringify(data)
    });

    const jsonResponse = await response.json();

    // 409 Conflict（重複データ）の場合は警告として表示
    if (response.status === 409) {
      statusDiv.className = 'warning';
      statusDiv.textContent = `⚠️ ${jsonResponse.message}`;
      return;
    }

    if (!response.ok) {
      throw new Error(`サーバーエラー: ${JSON.stringify(jsonResponse)}`);
    }

    statusDiv.className = 'success';
    statusDiv.textContent = `✅ 成功: ${jsonResponse.message}`;

  } catch (err) {
    statusDiv.className = 'error';
    statusDiv.textContent = `❌ エラー: ${err.message}`;
    console.error(err);
  } finally {
    btn.disabled = false;
  }
});
