// ページ内のデータを抽出するスクリプト
(function () {
	try {
		console.log("Starting data extraction...");

		// URLをデコード（日本語対応）
		const url = decodeURIComponent(window.location.href);
		console.log("Decoded URL:", url);

		// 日付を抽出（YYYY-MM-DD形式）
		// URL例: https://ana-slo.com/2025-11-30-店名-data/
		const dateMatch = url.match(/(\d{4}-\d{2}-\d{2})/);

		let date = "";
		if (dateMatch) {
			date = dateMatch[1];
		} else {
			// ページ内のh1/h2タグなどから日付を探す（バックアップ）
			const h1Text = document.querySelector('h1')?.textContent || "";
			const dateInText = h1Text.match(/(\d{4})年(\d{1,2})月(\d{1,2})日/);
			if (dateInText) {
				// YYYY-MM-DD形式に変換
				const y = dateInText[1];
				const m = dateInText[2].padStart(2, '0');
				const d = dateInText[3].padStart(2, '0');
				date = `${y}-${m}-${d}`;
			} else {
				return { error: "URLまたはページ内から日付を特定できませんでした。\nURL: " + url };
			}
		}

		// 店名の抽出（h2タグなどから）
		let shopName = "";

		// 1. URLから抽出
		if (date) {
			const parts = url.split(date + '-');
			if (parts.length > 1) {
				shopName = parts[1].replace(/-data\/?$/, '').replace(/\/$/, '');
			}
		}

		// 2. h2タグから抽出
		if (!shopName) {
			const h2Elements = document.getElementsByTagName('h2');
			for (let h2 of h2Elements) {
				const text = h2.textContent.trim();
				if (text.includes("店") && !text.includes("データ")) {
					shopName = text;
					break;
				}
			}
		}

		// 3. タイトルタグから抽出
		if (!shopName) {
			const title = document.title;
			const titleMatch = title.match(/^([^\s]+店)/);
			if (titleMatch) {
				shopName = titleMatch[1];
			}
		}

		if (!shopName) {
			return { error: "店名を特定できませんでした。\nURL: " + url };
		}

		// テーブルデータの抽出
		const rows = [];
		const table = document.getElementById('all_data_table');

		if (!table) {
			return { error: "データテーブル(all_data_table)が見つかりません" };
		}

		const trs = table.getElementsByTagName('tr');
		console.log(`Found ${trs.length} rows`);

		// ヘッダー行をスキップしてデータ行を処理
		for (let i = 1; i < trs.length; i++) {
			const tr = trs[i];
			const tds = tr.getElementsByTagName('td');

			// HTML構造:
			// td[0]: 機種名 (class="fixed01")
			// td[1]: 台番号
			// td[2]: G数
			// td[3]: 差枚
			// td[4]: BB
			// td[5]: RB
			// td[6]: 合成確率
			// td[7]: BB確率
			// td[8]: RB確率

			if (tds.length >= 9) {
				// 機種名
				let machineName = tds[0].textContent.trim();

				// 台番号
				let machineNumber = tds[1].textContent.trim();

				const rowData = {
					machine_name: machineName,
					machine_number: machineNumber,
					game_count: tds[2].textContent.trim().replace(/,/g, ''),
					diff_coins: tds[3].textContent.trim().replace(/,/g, '').replace('+', ''),
					bb_count: tds[4].textContent.trim(),
					rb_count: tds[5].textContent.trim(),
					composite_prob: tds[6].textContent.trim(),
					bb_prob: tds[7].textContent.trim(),
					rb_prob: tds[8].textContent.trim()
				};
				rows.push(rowData);
			}
		}

		if (rows.length === 0) {
			return { error: "データ行が見つかりませんでした。テーブル構造が変わっている可能性があります。" };
		}

		return {
			date: date,
			shop_name: shopName,
			rows: rows,
			url: url
		};

	} catch (e) {
		return { error: e.toString() };
	}
})();
